//AIM:Compute Kaiser window parameter Beta & its minimum length 
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//Let us consider the following specifications :
//│H(ω)│≤0.01          0 ≤│ω│≤0.25π
//0.95≤│H(ω)│≤1.05      0.35π ≤│ω│≤0.6π
//│H(ω)│≤0.01            0.65≤│ω│≤π
//The magnitude specifications of the FIR filter is given by
// 1-δp≤│H(ω)│≤ 1+δp for 0 ≤ω≤ωp
// 0≤│H(ω)│≤ δs  for ωs≤ω≤π
//On comparing,we get 1-δp=0.95
del_p=0.05;
del_s=0.01;
omega_p=0.6*(%pi);
omega_s=0.65*(%pi);
del_omega=omega_s-omega_p;
//δ ia minimum of δp and minimum of δs
del=0.05;
//Attenuation A is given as
A=((-20)*(log10(del)));
disp("dB",A,"Attenuation(A)=")
//Calculating value of β
beeta=(A-21)^(0.4)+0.07886+(A-21);
disp(beeta,"β=")
//The length of filter is (M+1)
//The value of M is calculated as follows
M=((A-8)/(2.285*(del_omega)));
disp(M,"M=")
